<?php

/**
 * Class PagePositionMapper
 */
class PagePositionMapper
{
    /**
     * PagePositionMapper constructor.
     *
     * This class cannot be instantiated
     */
    private function __construct()
    {
    }
    
    
    /**
     * The position inside the json file differs from the actually needed one
     * in the Database. This method translates the position
     *
     * @param string $position
     *
     * @return string
     * @throws \Exception
     */
    public static function getPagePositionForDatabase(string $position): string
    {
        switch ($position) {
            case 'info':
                
                return 'pages_info';
            
            case 'mainNavigation' :
                
                return 'pages_main';
            
            case 'infoBox' :
                
                return 'pages_info_box';
            
            case 'secondaryNavigation' :
                
                return 'pages_secondary';
            
            default:
                
                throw new Exception('Unknown PagePosition(' . $position . ')');
        }
    }
    
    
    /**
     * @param string $position
     *
     * @return string
     * @throws \Exception
     */
    public static function getPagePositionFromDatabase(string $position): string
    {
        switch ($position) {
            case 'pages_info':
                
                return 'info';
            
            case 'pages_main' :
                
                return 'mainNavigation';
            
            case 'pages_info_box' :
                
                return 'infoBox';
            
            case 'pages_secondary' :
                
                return 'secondaryNavigation';
            
            default:
                
                throw new Exception('Unknown PagePosition(' . $position . ')');
        }
    }
}